/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan
/* - Contents: α׷ A/D CH0 CH1 ä Unlimited scan
/*     ̿Ͽ A/D convert ϰ   Ϸ ϴ Դϴ.
/*      α׷ scan ۸  handlingϴ  ְ
/*     ֽϴ.
/*
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define NUM_CH	2	/* Number of channels */
#define S_FREQ	1000	/* Scan freq. -> 1000 Hz */
#define MSB		40960	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */

void main (void)
{
	HANDLE hDevice;
	int ch_list[2] = {0, 4};  /* Scan channel list : 0  4 ä */
	FILE *fp;
	short *pScanBuf;
	ULONG c, prv_cnt, cur_cnt;
	UINT idx1, idx2;

	/* Load DLL */
	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	/* start unlimited scan */
	long act_freq = COMI_US_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!\n");
		printf("%s", COMI_ErrorString (COMI_LastError())); 
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	/* Create a file to save data */
	if((fp = fopen ("c:\\ComiUscan.txt", "w")) == NULL){
		printf("͸     ϴ.\nƹŰ  ˴ϴ.\n");
		_getch();
		COMI_US_Stop (hDevice, TRUE);
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
	}
	fprintf (fp,"   CH0    CH4\n");
	
	pScanBuf = COMI_US_GetBufPtr(hDevice); // Get scan buffer pointer
	prv_cnt = 0; // initialize count variable
	
	while(!kbhit())
	{
		cur_cnt = COMI_US_CurCount (hDevice);
		
		/* prv_cnt   : end count of previously processed data block     */
		/* prv_cnt+1 : initial count of newly scaned data block         */
		/* cur_cnt   : end count of current newly scanned data block    */
		for(c = prv_cnt+1; c <= cur_cnt; c++)
		{
			/* COMI_US_SBPos (..) Լ ̿Ͽ  ä ۻ ε ´. */
			/* ̶ ι° Ķʹ äιȣ ƴ϶ ä Ʈ ̴.   */
			/* , CH0 0̰, CH4 1 ȴ.                                     */   
			idx1 = COMI_US_SBPos (hDevice, 0, c);
			idx2 = COMI_US_SBPos (hDevice, 1, c);

			/* File ͸ Ѵ. Ʒ ڵ Voltage ϴ */
			/*  ƴϰ 0~4095(SD201 -32767~32767)  ȴ. ̸ Voltage  */
			/* ȯؼ Ϸ Ʒ ּó ڵ带 ̿ϸȴ.     */
			/* , SD201 쿡 COMI_Digit16ToVolt()Լ ؾѴ.*/
			//float ch0_volt, ch4_volt;			 
			//ch0_volt = COMI_DigitToVolt (pScanBuf[idx1], -10, 10);
			//ch4_volt = COMI_DigitToVolt (pScanBuf[idx2], -10, 10);
			//fprintf (fp, "%6.2f %6.2f\n", ch0_volt, ch4_volt);
			fprintf (fp, "%6d %6d\n", pScanBuf[idx1], pScanBuf[idx2]);
		}
		printf("Saved scan count = %u\n", cur_cnt);
		prv_cnt = cur_cnt;
	}
	
	COMI_US_Stop (hDevice, TRUE);
	fclose(fp);

	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
